/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.resource.loader.impl;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.resource.loader.api.ResourcePackActivationType;
import org.quiltmc.qsl.resource.loader.impl.ModNioResourcePack;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class QuiltBuiltinResourcePackProfile
extends class_3288 {
    private static final Logger LOGGER = LogUtils.getLogger();

    static QuiltBuiltinResourcePackProfile of(ModNioResourcePack pack) {
        try {
            class_3272 metadata = (class_3272)pack.method_14407((class_3270)class_3272.field_14202);
            if (metadata == null) {
                LOGGER.warn("Couldn't find pack meta for pack {}", (Object)pack.method_14409());
                return null;
            }
            return new QuiltBuiltinResourcePackProfile(pack, metadata);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't get pack info for: {}", (Object)e.toString());
            return null;
        }
    }

    private QuiltBuiltinResourcePackProfile(ModNioResourcePack pack, class_3272 metadata) {
        super(pack.method_14409(), pack.getDisplayName(), pack.getActivationType() == ResourcePackActivationType.ALWAYS_ENABLED, () -> pack, metadata, pack.type, class_3288.class_3289.field_14280, (class_5352)new BuiltinResourcePackSource(pack));
    }

    public class_3281 method_14460() {
        return class_3281.field_14224;
    }

    public static class BuiltinResourcePackSource
    implements class_5352 {
        private static final class_2561 SOURCE_BUILTIN_TEXT = new class_2588("pack.source.builtin");
        private final ModNioResourcePack pack;
        private final class_2561 text;
        private final class_2561 tooltip;

        BuiltinResourcePackSource(ModNioResourcePack pack) {
            String modName = pack.modInfo.getName();
            if (modName == null) {
                modName = pack.modInfo.getId();
            }
            this.pack = pack;
            this.text = SOURCE_BUILTIN_TEXT;
            this.tooltip = new class_2588("options.generic_value", new Object[]{SOURCE_BUILTIN_TEXT, modName});
        }

        public class_2561 decorate(class_2561 description) {
            return new class_2588("pack.nameAndSource", new Object[]{description, this.text}).method_27692(class_124.field_1080);
        }

        public class_2561 getTooltip() {
            return this.tooltip;
        }
    }
}

